<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Column extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "column";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[column lg=\"6\"]...content...[/column]\n[column xl=\"6\" lg=\"6\" sm=\"6\" xs=\"12\"]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "xl",
			"hint"		=> "1-12 bootstrap colums"
		),

		array(
			"name"		=> "lg",
			"hint"		=> "1-12 bootstrap colums"
		),

		array(
			"name"		=> "md",
			"hint"		=> "1-12 bootstrap colums"
		),

		array(
			"name"		=> "sm",
			"hint"		=> "1-12 bootstrap colums"
		),

		array(
			"name"		=> "xs",
			"hint"		=> "1-12 bootstrap colums"
		),

		array(
			"name"		=> "bg",
			"hint"		=> "#hexcode, default: transparent"
		),

		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization"
		)	
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$css = array();
		$style = array();

		$css[] = "isotope-element";
		$vars = $data["vars"];

		if ($vars["xl"]) {	$css[] = "col-xl-" . $vars["xl"]; }
		if ($vars["lg"]) {	$css[] = "col-lg-" . $vars["lg"]; }
		if ($vars["md"]) {	$css[] = "col-md-" . $vars["md"]; }
		if ($vars["sm"]) {	$css[] = "col-sm-" . $vars["sm"]; }
		if ($vars["xs"]) {	$css[] = "col-" . $vars["xs"]; }

		if ($vars["class"]) { $css[] = $vars["class"]; }

		//force to add the normal colors
		//$css[] = "nc";

		
		return array(
			"content"	=> $this->tpl->blockReplace(
					"Main",
					array(
						"css"		=> implode(" " , $css),
						"content"	=> $vars["content"],
						"before"	=> $data["before"],
						"after"		=> $data["after"],
					),
					$this->getBackground($vars["bg"])
				),
			"before"	=> "",
			"after"		=> "",
		);
	}
	
	
}